<?php
/**
 * Recent post widget
 * @package automatic
 */

class WP_Automatic_Widget_Featured_Products extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_featured_product', 'description' => esc_html__( "Display Featured Products", "automatic") );
        parent::__construct( 'automatic-feature', esc_html__( '[Automatic] Featured Products', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_featured_product';
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        $args1 = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => 3,
            'meta_key' => '_featured',
            'meta_value' => 'yes',
        );
        $rquery = new Wp_Query($args1);
        if ( $rquery -> have_posts() ) :
            echo '<ul class= "pro-widget">';
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                    wc_get_template_part( 'content', 'product-list' );
                endwhile;
                wp_reset_postdata();
                echo '</ul>';
        endif;
        echo $args['after_widget'];
    }
}
